/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.property;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cz.insophy.inplan.mrp.CustomerRequest;
import cz.insophy.inplan.mrp.SupplyRequest;
import cz.insophy.inplan.property.Propertized;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.CumulativeAction;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.shop.RebuildType;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class PropertyDefinitions {
    private Class<? extends Propertized> effectivity;
    private Map<PropertyDefinition, Integer> propertyLocations;
    private Map<String, Integer> namedPropertyLocations;

    public static Map<Class<? extends Propertized>, PropertyDefinitions> splitPropertyDefinitions(Collection<PropertyDefinition> propdefs, boolean addEmptyDefinitions) {
        LinkedHashMultimap<Class, PropertyDefinition> splittedPropdefs = LinkedHashMultimap.create();
        for (PropertyDefinition pd : propdefs) {
            splittedPropdefs.put(pd.getEffectivity(), pd);
        }
        LinkedHashMap<Class<? extends Propertized>, PropertyDefinitions> propertyDefinitions = Maps.newLinkedHashMap();
        HashSet<Class> addedEffectivities = Sets.newHashSet();
        addedEffectivities.add(Material.class);
        addedEffectivities.add(Product.class);
        addedEffectivities.add(Workplace.class);
        addedEffectivities.add(Workplace.class);
        addedEffectivities.add(GeneralizedOrderRequest.class);
        addedEffectivities.add(GeneralizedActionRequest.class);
        addedEffectivities.add(SupplyRequest.class);
        addedEffectivities.add(CustomerRequest.class);
        addedEffectivities.add(RebuildType.class);
        addedEffectivities.add(Action.class);
        addedEffectivities.add(CumulativeAction.class);
        for (Class effectivity : splittedPropdefs.keySet()) {
            addedEffectivities.remove(effectivity);
            propertyDefinitions.put(effectivity, new PropertyDefinitions(splittedPropdefs.get(effectivity), effectivity));
        }
        if (addEmptyDefinitions) {
            for (Class effectivity : addedEffectivities) {
                propertyDefinitions.put(effectivity, new PropertyDefinitions(effectivity));
            }
        }
        return propertyDefinitions;
    }

    private PropertyDefinitions(Class<? extends Propertized> effectivity) {
        this.effectivity = effectivity;
        this.propertyLocations = Collections.emptyMap();
        this.namedPropertyLocations = Collections.emptyMap();
    }

    public PropertyDefinitions(Collection<PropertyDefinition> propdefs, Class<? extends Propertized> effectivity) {
        this.effectivity = effectivity;
        this.propertyLocations = Maps.newLinkedHashMap();
        this.namedPropertyLocations = Maps.newLinkedHashMap();
        for (PropertyDefinition pd : propdefs) {
            Preconditions.checkState(effectivity.equals(pd.getEffectivity()), "The property definition does not correspond to the effectivity.");
            if (this.propertyLocations.containsKey(pd)) continue;
            this.propertyLocations.put(pd, this.propertyLocations.size());
            this.namedPropertyLocations.put(pd.getName(), this.namedPropertyLocations.size());
        }
    }

    public Collection<PropertyDefinition> getPropertyDefinitions() {
        return this.propertyLocations.keySet();
    }

    public Integer getPosition(PropertyDefinition propdef) {
        return this.propertyLocations.get(propdef);
    }

    public Integer getPosition(String name) {
        return this.namedPropertyLocations.get(name);
    }

    public Class<? extends Propertized> getEffectivity() {
        return this.effectivity;
    }
}

